# box2d_specification_dicts
import copy
from ACState.object_dict import ObjDict

name_order = ["continuous_actions", "num_balls", "poly_ids", "num_poly_inst", 
            "dyn_damping", "density", "init_velocity", "general_radius_min", "general_radius_max",
            "use_target", "target_form", "target_damping", "target_radius", 
            "target_density", "target_init_vel", "control_damping", "control_radius", "control_density", 
            "grav_domain", "phyre_path", "length", "width", "force_scaling", "render_size",
            "min_valid", "max_valid", "force_live",
            "max_steps", "goal_epsilon", "goal_form"]

default = ObjDict()
default.continuous_actions = True
default.num_balls = 2
default.poly_ids = [0,3,7]
default.num_poly_inst = 1
default.use_target = True
default.dyn_damping = 1
default.density = 1
default.init_velocity = 1
default.general_radius_min = 1
default.general_radius_max = 1
default.target_form = "Ball"
default.target_init_vel = 0.0
default.target_damping = 0
default.target_radius = 1
default.target_density = 1
default.control_damping = 0.0
default.control_radius = 1
default.control_density = 1.0
default.grav_domain = False
default.phyre_path = ""
default.length = 10
default.width = 10
default.force_scaling = 100
default.render_size = 120
default.min_valid = 1
default.max_valid = 7
default.force_live = "Target"
default.max_steps = 50
default.goal_epsilon = -1
default.goal_form = "Target"

default_all = copy.deepcopy(default)
default_all.min_valid = 6

poly_ball = copy.deepcopy(default)
poly_ball.num_balls = 0
poly_ball.poly_ids = [0]
poly_ball.max_valid = 3

poly_ball_all = copy.deepcopy(poly_ball)
poly_ball_all.min_valid = 3


ball_poly = copy.deepcopy(poly_ball)
ball_poly.num_balls = 1
ball_poly.use_target = False
ball_poly.force_live = "Poly3vert0form"

ball_poly_all = copy.deepcopy(ball_poly)
ball_poly_all.min_valid = 3

ctrl_poly = copy.deepcopy(poly_ball)
ctrl_poly.use_target = False
ctrl_poly.force_live = "Poly3vert0form"
ctrl_poly.max_valid = 2



ctrl_all = copy.deepcopy(poly_ball)
ctrl_all.num_balls = 0
ctrl_all.use_target = True
ctrl_all.poly_ids = [0]
ctrl_all.max_valid = 3

ctrl_small_all = copy.deepcopy(ctrl_all)
ctrl_small_all.num_balls = 0
ctrl_small_all.poly_ids = []
ctrl_small_all.num_poly_inst = 0
ctrl_small_all.min_valid = 2
ctrl_small_all.max_valid = 2


goal_target = copy.deepcopy(default)
goal_target.max_steps = 200
goal_target.num_balls = 0
goal_target.use_target = True
goal_target.poly_ids = []
goal_target.general_radius_min = 0.7
goal_target.general_radius_max = 0.7
goal_target.target_damping = 1
goal_target.target_radius = 0.5
goal_target.target_density = 0.1
goal_target.control_damping = 2.0
goal_target.control_radius = 0.5
goal_target.control_density = 0.75
goal_target.force_scaling = 200
goal_target.render_size = 240
goal_target.min_valid = 2
goal_target.max_valid = 2
goal_target.goal_epsilon = 1

goal_target_hard = copy.deepcopy(goal_target)
goal_target_hard.target_radius = 0.3
goal_target_hard.control_radius = 0.3

goal_target_hard_vel = copy.deepcopy(goal_target_hard)
goal_target_hard_vel.target_init_vel = 5.0


goal_target_very_hard = copy.deepcopy(goal_target)
goal_target_very_hard.target_radius = 0.1
goal_target_very_hard.control_radius = 0.1

goal_target_obstacles = copy.deepcopy(goal_target)
goal_target_obstacles.target_radius = 0.3
goal_target_obstacles.control_radius = 0.3
goal_target_obstacles.num_balls = 2
goal_target_obstacles.poly_ids = [0,1,4]
goal_target_obstacles.num_poly_inst = 1
goal_target_obstacles.general_radius_min = 0.7
goal_target_obstacles.general_radius_max = 0.7
goal_target_obstacles.dyn_damping = 2 # more damping to prevent spurious interactions
goal_target_obstacles.init_velocity = 0.2
goal_target_obstacles.min_valid = 7
goal_target_obstacles.max_valid = 7

goal_target_obstacles_HD = copy.deepcopy(goal_target_obstacles)
goal_target_obstacles_HD.render_size = 1080


goal_target_obstacles_few = copy.deepcopy(goal_target_obstacles)
goal_target_obstacles_few.num_balls = 1
goal_target_obstacles_few.poly_ids = [0]
goal_target_obstacles_few.min_valid = 4
goal_target_obstacles_few.max_valid = 4

goal_target_obstacles_few_HD = copy.deepcopy(goal_target_obstacles_few)
goal_target_obstacles_few_HD.render_size = 1080


goal_ctrl = copy.deepcopy(goal_target)
goal_ctrl.min_live = 2
goal_ctrl.max_live = 2
goal_ctrl.use_target = False
goal_ctrl.force_live = "Control"
goal_ctrl.goal_form = "Control"

# allow for null values
goal_target_null = copy.deepcopy(goal_target)
goal_target_null.target_init_vel = 0.2
goal_target_null.min_valid = 1
goal_target_null.max_valid = 2

goal_target_hard_null = copy.deepcopy(goal_target_hard)
goal_target_hard_null.target_init_vel = 0.2
goal_target_hard_null.min_valid = 1
goal_target_hard_null.max_valid = 2

goal_target_very_hard_null = copy.deepcopy(goal_target_very_hard)
goal_target_very_hard_null.target_init_vel = 0.2
goal_target_very_hard_null.min_valid = 1
goal_target_very_hard_null.max_valid = 2

goal_target_obstacles_null = copy.deepcopy(goal_target_obstacles)
goal_target_obstacles_null.target_init_vel = 0.2
goal_target_obstacles_null.min_valid = 1
goal_target_obstacles_null.max_valid = 7
goal_target_obstacles_null.init_velocity = 0.2



def dict_to_tuple(attr_dict):
    return tuple((attr_dict[name] for name in name_order))


box2d_variants = {"default": dict_to_tuple(default),
                    "1-poly-ball": dict_to_tuple(poly_ball),
                    "1-ball-poly": dict_to_tuple(ball_poly),
                    "1-ctrl-poly": dict_to_tuple(ctrl_poly),
                    "goal-ctrl-target": dict_to_tuple(goal_target),
                    "goal-ctrl-target-hard": dict_to_tuple(goal_target_hard),
                    "goal-ctrl-target-vel": dict_to_tuple(goal_target_hard_vel),
                    "goal-ctrl-target-very-hard": dict_to_tuple(goal_target_very_hard),
                    "goal-ctrl-target-obstacles": dict_to_tuple(goal_target_obstacles),
                    "goal-ctrl-target-obstacles-HD": dict_to_tuple(goal_target_obstacles_HD),
                    "goal-ctrl-target-obstacles-few": dict_to_tuple(goal_target_obstacles_few),
                    "goal-ctrl-target-obstacles-few-HD": dict_to_tuple(goal_target_obstacles_few_HD),
                    "goal-ctrl": dict_to_tuple(goal_ctrl),
                    "goal-ctrl-target-null": dict_to_tuple(goal_target_null),
                    "goal-ctrl-target-hard-null": dict_to_tuple(goal_target_hard_null),
                    "goal-ctrl-target-very-hard-null": dict_to_tuple(goal_target_very_hard_null),
                    "goal-ctrl-target-obstacles-null": dict_to_tuple(goal_target_obstacles_null),
                    "default-all": dict_to_tuple(default_all),
                    "1-ball-poly-all": dict_to_tuple(ball_poly_all),
                    "1-ctrl-all": dict_to_tuple(ctrl_all),
                    "1-ctrl-small-all": dict_to_tuple(ctrl_small_all),
}

# box2d_variants = {"default": (True,2, [0,3,7], 1, 1, 1, True, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 10, 10, 100, 120, 1, 6, "Target", 50, -1.0, "Target"),
#                    "1-poly-ball": (True, 1, [0], 1, 1, 1, False, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 10, 10, 100, 120, 1, 3, "Ball", 50, -1.0, "Target"),
#                    "1-ball-poly": (True, 1, [0], 1, 1, 1, False, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 10, 10, 100, 120, 1, 3, "Poly3vert0form", 50, -1.0, "Target"),
#                    "1-ctrl-poly": (True, 0, [1], 1, 1, 1, False, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 7, 7, 100, 120, 2, 2, "Poly3vert1form", 50, -1.0, "Target"),
#                    "goal-ctrl-target": (True, 0, [], 0, 1, 1, True, 0.5, 1, "Ball", 1, 0.5, 0.1, 2.0, 0.5, 0.75, False, "", 7, 7, 200, 240, 2, 2, "Target", 50, 0.01, "Target"),
#                    "goal-ctrl-target-hard": (True, 0, [], 0, 1, 1, True, 0.5, 1, "Ball", 1, 0.3, 0.1, 2.0, 0.3, 0.75, False, "", 7, 7, 200, 240, 2, 2, "Target", 50, 0.01, "Target"),
#                    "goal-ctrl-target-very-hard": (True, 0, [], 0, 1, 1, True, 0.5, 1, "Ball", 1, 0.1, 0.1, 2.0, 0.1, 0.75, False, "", 7, 7, 200, 240, 2, 2, "Target", 50, 0.01, "Target"),
#                    "goal-ctrl-target-obstacles": (True, 1, [0,3,7], 1, 0.3, 0.8, True, 0.5, 1, "Ball", 1, 0.1, 0.1, 2.0, 0.1, 0.75, False, "", 7, 7, 200, 240, 2, 2, "Target", 50, 0.01, "Target"),
#                    "goal-ctrl": (True, 0, [], 0, False, 0.5, 1, 1, 1, "Ball", 1, 0.1, 0.1, 0.0, 0.1, 1.0, False, "", 7, 7, 100, 240, 2, 2, "Control", 50, 0.01, "Control"),

#                    "default-all": (True,1, [0,3,7], 1, 1, 1, True, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 10, 10, 100, 120, 6, 6, "Target", 50, -1.0, "Target"),
#                    "1-ball-poly-all": (True, 1, [1], 1, 1, 1, True, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 10, 10, 100, 120, 3, 3, "Target", 50, -1.0, "Target"),
#                    "1-ctrl-all": (True, 1, [0], 1, 1, 1, True, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 7, 7, 100, 120, 2, 2, "Target", 50, -1.0, "Target"),
#                    "1-ctrl-small-all": (True, 0, [], 0, 1, 1, True, 0, 1, "Ball", 0, 1, 1, 0.0, 1, 1.0, False, "", 7, 7, 100, 120, 2, 2, "Target", 50, -1.0, "Target"),
#                     }
                                            # continuous_actions, num_balls, poly_ids, num_poly_inst, use_target,\
                                            # dyn_damping, density, general_radius_min, general_radius_max,\
                                            # target_form, target_damping, target_radius, \
                                            # target_density, control_damping, control_radius, control_density, \
                                            # grav_domain, phyre_path, length, width, force_scaling, render_size,\
                                            # min_valid, max_valid, force_live, \
                                            # max_steps, goal_epsilon, goal_form = box2d_variants[variant]
